//------------- Requires ------------------
/*const multer = require('multer');
const path = require('path');
const connection = require('../../config/database');
const Album = connection.models.Album;
const File = connection.models.File;
const User = connection.models.User;
const Project = connection.models.Project;
const fs = require('fs-extra')
const generateDate = require("../../lib/publicFunctions").generateDate;
//const uploadFile = require('../../lib/uploadFileFTP').uploadFile;
const mPath = require('mongoose-mpath')
const socketiofileupload = require('socketio-file-upload')
var Client = require('ftp');
require("dotenv").config({path: "./.env"});
//----------------------------------------FS

// const dir = './assets/assets/img'
const desiredMode = 0o2775
const options = {
    mode: 0o2775
}

// With async/await and an options object, containing mode:
async function exampleMode (directory) {
    try {
        await fs.ensureDir(directory, options)
        console.log('success!')
    } catch (err) {
        console.error(err)
    }
}

//---------------------------------------Fs

//---------------------------------------------------------upload
exports.getUploadAlbumFiles = async (req, res, next) => {
    console.log("upload file")
    const imageTypes = ['png', 'jpg', 'jpeg']
    const videoTypes = ['mp4', 'mkv']
    const audioTypes = ['mp3']
    const documentTypes = ['pdf']

    var album = await Album.findOne({_id: req.params.id})
    console.log("album")
    console.log(album)
    var parents = await album.getAncestors({Removed:false});
    console.log("parents")
    console.log(parents)
    var parentsId = parents.map(a => a.UniqueName);
    console.log("parentsId")
    console.log(parentsId)
    var url = "";
    for(var i=0; i < parentsId.length; i++) {
        url = url + parentsId[i] + '/'
    }
    // if(parents.length == 0) {
    //     url = album.UniqueName
    // } else {
    // }
    url = url + album.UniqueName

    console.log("url")
    console.log(url)

    var address = './assets/RTL/vendor/images';

    var newFile;
    var name;
    var type;

    await uploadFile('./assets/vendor/file/album', address, req.params.fileName)

    try {
        await fs.remove('./assets/vendor/file/album/' + req.params.fileName)
        console.log('success!')
    } catch (err) {
        console.error(err)
    }

    name = req.params.fileName.split(".")
    if(imageTypes.includes(name[name.length - 1])) {
        type = 0
    } else if(videoTypes.includes(name[name.length - 1])){
        type = 1
    } else if(audioTypes.includes(name[name.length - 1])){
        type = 2
    } else if(documentTypes.includes(name[name.length - 1])){
        type = 3
    } else {
        type = 4
    }
    newFile = new File({
        Name: req.params.fileName,
        Alt: " آژانس تبلیغاتی آنسه",
        Type: type,
        SmallCaption:"آژانس تبلیغاتی آنسه",
        Caption:"آژانس تبلیغاتی آنسه",
        IsCover:false,
        Status: 0,
        TarikhPersian: await generateDate(0, 'fa'),
        Views: '0',
        Likes: '0',
        Url: url,
        AdminConfirm: 0,
        Album: album._id,
        Removed: false
    })

    await newFile.save(async function(err, result){
        if (err) {
            req.flash('message', await generateMessage(406));
            console.log(generateSystemLog("getUploadAlbumFiles", 410, req, err))
            res.redirect(req.get("referer"));
        } else {
            req.flash('message', await generateMessage(205));
            console.log(generateSystemLog("getUploadAlbumFiles", 200, req))
            res.redirect(req.get("referer"));
        }
    })

    res.send({ file : newFile, status: 200 });

};

exports.getUploadUserFiles = async (req, res, next) => {

    console.log("getUploadUserFiles")

    var user = await User.findOne({_id: req.user._id})

    console.log("upload file")
    const imageTypes = ['png', 'jpg', 'jpeg']
    const videoTypes = ['mp4', 'mkv']
    const audioTypes = ['mp3']
    const documentTypes = ['pdf']

    var alt = ""

    switch (req.params.type.toLowerCase().trim()) {
        case "profileimage":
            alt = "تصویر پروفایل"
            break;
        case "resume":
            alt = "نمونه کارها"
            break;
        case "project":
            alt = "تصاویر پروژه"
            break;
        default:
            alt = "تصاویر پروژه"
    }

    var album = await Album.findOne({Name: req.user.Mobile})
    console.log("album")
    console.log(album)

    url = album.UniqueName

    console.log("url")
    console.log(url)

    await  exampleMode('./assets/assets/file/album/' + url);

    var newFile;
    var name;
    var type;

    await fs.moveSync('./assets/assets/file/album/'+ req.params.fileName , './assets/assets/file/album/' + url + '/' + req.params.fileName, { overwrite: true })
    name = req.params.fileName.split(".")
    if(imageTypes.includes(name[name.length - 1])) {
        type = 0
    } else if(videoTypes.includes(name[name.length - 1])){
        type = 1
    } else if(audioTypes.includes(name[name.length - 1])){
        type = 2
    } else if(documentTypes.includes(name[name.length - 1])){
        type = 3
    } else {
        type = 4
    }
    newFile = new File({
        Name: req.params.fileName,
        Alt: alt,
        Type: type,
        SmallCaption:"تصاویر کاربر",
        Caption:"تصاویر کاربر",
        IsCover:false,
        Status: 0,
        TarikhPersian: await persianDate(0),
        Views: '0',
        Likes: '0',
        Url: url,
        AdminConfirm: 0,
        Album: album._id,
        Removed: false
    })

    await newFile.save()

    var model;

    switch (req.params.type.toLowerCase().trim()) {
        case "profileimage":
            model = await User.findOne({_id: user._id}).populate("ProfileImage")

            console.log("model.ProfileImage._id")
            console.log(model.ProfileImage._id)

            await  File.updateOne({
                    _id: model.ProfileImage._id
                },{
                    $set: {
                        Removed : true
                    }
                },{ safe: true, multi:true }
            );

            model.ProfileImage = newFile
            break;
        case "resume":
            model = await User.findOne({_id: req.params.modelId}).populate("Files")
            model.Files.push(newFile)
            break;
        case "project":
            model = await Project.findOne({_id: req.params.modelId}).populate("Files")
            model.Files.push(newFile)
            break;
        default:
            model = await Project.findOne({_id: req.params.modelId}).populate("Files")
            model.Files.push(newFile)
    }

    await model.save();

    res.send({ "file" : newFile, "status: ": 200 });

};
//----------------------------------------------------------upload

//----------------------------------------------------------Remove
exports.getRemoveAlbumFiles = async (req, res) => {
    var file = await File.findOne({_id: req.params.fileId})
    await  File.updateOne({
            _id: req.params.fileId
        },{
            $set: {
                Removed : true
            }
        },{ safe: true, multi:true },
        async  function removeConnectionsCB(err, obj) {
            if (err) {
                res.send(err)
            }else {
                res.redirect(req.get('referer'));
            }
        }
    );
};

exports.getRemoveUserFiles = async (req, res) => {

    console.log("getRemoveUserFiles")

    var user = await User.findOne({_id: req.user._id})
    var file = await File.findOne({_id: req.params.imageID})

    switch (req.params.type.toLowerCase().trim()) {
        case "resume":
            model = await User.findOne({_id: req.params.modelId}).populate("Files")
            model.Files.pull(file)
            break;
        case "project":
            model = await Project.findOne({_id: req.params.modelId}).populate("Files")
            model.Files.pull(file)
            break;
        default:
            model = await Project.findOne({_id: req.params.modelId}).populate("Files")
            model.Files.pull(file)
    }

    model.save();

    await  File.updateOne({
            _id: req.params.imageID
        },{
            $set: {
                Removed : true
            }
        },{ safe: true, multi:true },
        async  function removeConnectionsCB(err, obj) {
            if (err) {
                res.send(err)
            }else {

                try {
                    await fs.remove('./assets/assets/file/album/'+ file.Url +'/'+ file.Name)
                    console.log('success!')
                } catch (err) {
                    console.error(err)
                }
                res.redirect(req.get('referer'));
            }
        }
    );
};
//----------------------------------------------------------Remove

//----------------------------------------------------------AddAlt
exports.postEditFile = async (req, res, next) => {
    File.updateOne(
        {
            _id: req.params.imageID,
        },
        {
            $set: {
                Alt : req.body.Alt,
                Caption: req.body.Caption
            },
        },
        { multi: false, runValidators: true },
        function (err, docs) {
            if (err) {
                console.log(err);
            }
            switch (req.params.platform.toLowerCase()) {
                case "admin":
                    res.redirect(req.get("referer"));
                    break;
                case "website":
                    res.redirect(req.get("referer"));
                    break;
                case "mobile":
                    res.send({ status: 200, data: docs, message: "آپلود فایل" });
                    break;
                default:
                    res.redirect(req.get("referer"));
            }
        }
    );
};
//----------------------------------------------------------AddAlt
*/