//------------- Requires ------------------
const generateSystemLog = require('../../lib/systemLog').generateSystemLog;
const generateMessage = require('../../lib/flashMessage').generateMessage;
const generateDate = require('../../lib/publicFunctions').generateDate;
const createFolder = require('../../lib/uploadFileFTP').createFolder;
const report = require('../../lib/report').setReport;
const config = require("../../config/general");
const connection = config.connection;
const User=connection.models.User;
require('dotenv').config({path: './.env'});
const jwt = require('jsonwebtoken')
const bcrypt=config.bcrypt;

//------------- Requires ------------------
//----------------------------------------------------------------------admin
//------------------------------List----------------------------
exports.getRegister = async (req, res) => {
    
    res.render("register/register",{messages : req.flash('register')})

};
exports.postRegister = async (req,res)=>{

    try {
        const { UserName, FirstName, LastName, Email, Password, confirmPassword } = req.body;

        if(!UserName){
            req.flash('register',{type:"error", message: 'UserName inpute is empty' });
            return res.redirect('/register'); // توقف اجرای کد
        }

        if(!Email){
            req.flash('register',{type:"error", message: 'Email inpute is empty' });
            return res.redirect('/register'); // توقف اجرای کد

        }

        if(!FirstName){

            req.flash('register',{type:"error", message: 'FirtName inpute is empty' });
            return res.redirect('/register'); // توقف اجرای کد
        }
        if(!LastName){

            req.flash('register',{ message: 'LastName inpute is empty' });
            return res.redirect('/register');
        }
        if(!Password){
            req.flash('register',{type:"error", message: 'Password inpute is empty' });
            return res.redirect('/register');
        }
        if(!confirmPassword){
            req.flash('register',{type:"error", message: 'confirmPassword inpute is empty' });
            return res.redirect('/register');
        }
        // 1. بررسی وجود کاربر با ایمیل یا نام کاربری مشابه
        const existingUserByEmail = await User.findOne({ Email });
        const existingUserByUsername = await User.findOne({ UserName });

        if (existingUserByEmail) {
            req.flash('register',{type:"error", message: 'Email is already is use' });
            return res.redirect('/register');
        }

        if (existingUserByUsername) {

            req.flash('register',{type:"error", message: 'Username is already is use' });
            return res.redirect('/register');
        }

        // 2. بررسی تطابق password و confirmPassword
        if (Password !== confirmPassword) {
            req.flash('register',{type:"error", message: 'Passwords do not match' });
            return res.redirect('/register');
        }

        // 3. هش کردن رمز عبور
        const hashedPassword = await bcrypt.hash(Password, 10);

        // 4. ذخیره‌سازی کاربر جدید در دیتابیس
        const newUser = new User({
            UserName,
            Name:FirstName,
            LastName,
            Email,
            Password: hashedPassword,
            Status:true,
            IdCheck:Math.floor(Math.random() * 10000),
            Follower:[],
            Following:[],
            UserType:null,
            Admin:false
        });

        try {
            await newUser.save();
            console.log("newUser")
            console.log(newUser)
            return res.redirect('/profile');
        } catch (error) {
            console.error("Error registering user:", error);
            req.flash('register',{type:"error", message: 'Server error' });
            return res.redirect('/login');
        }
    } catch (error) {
        console.log(error);
        req.flash('register',{type:"error", message: 'Server error' });
        return res.redirect('/register');
    }
}