//------------- Requires ------------------

const config = require("../../config/general");
const connection = config.connection;
const User=connection.models.User;
require('dotenv').config({path: './.env'});
const generatePassword = require('../../lib/token.js')
const Email = require('../../lib/email.js')
const jwt = require('jsonwebtoken')
const bcrypt = require('bcryptjs');

//------------- Requires ------------------
//----------------------------------------------------------------------admin
//------------------------------List----------------------------
exports.getReset = async (req, res) => {
    console.log(req.body)
    console.log(req.flash('resetPassword'))
    console.log(req.flash('resetPassword_succsess'))
    res.render("resetPassword/resetPassword",{ messages_error: req.flash('resetPassword'),messages_succsess:req.flash('resetPassword_succsess')})
};
exports.postReset=async(req,res)=>{
    try {
        const {email} = req.body;
        if(!email){
            req.flash('resetPassword', {type:"error", message: 'The email field is empty' });
            return res.redirect('/resetPassword');
        }
        const user = await User.findOne({ Email: email });
        if (!user) {
            req.flash('resetPassword', {type:"error", message: 'User is not registered with this email' });
            return res.redirect('/resetPassword');
        }
        var gPass = await generatePassword.generatePassword()
        console.log("gPass")
        console.log(gPass)
        await Email.sendEmail(email, 'Password Reset', `new Password : ${gPass}`);
        const hashedPassword = await bcrypt.hash(gPass, 10);
        const updateResult = await User.updateOne( // await را اضافه کنید
            { _id: user._id },
            { $set: { Password: hashedPassword } }
        );

        if (updateResult.modifiedCount === 0) {
            req.flash('resetPassword', {type:"error", message: 'User not found or password not changed' });
            return res.redirect('/resetPassword');
        }

        req.flash('login', {type:"success", message: 'Password changed successfully' });
        return res.redirect('/login');

    } catch (error) {
        // res.status(500).json({ message:error });
        console.log(error)
    }
}
