//------------- Requires ------------------
const jwt = require('jsonwebtoken')
const connection = require('../config/database');
require("dotenv").config({path: "../../.env"});
//------------- Requires ------------------
//------------------------------Athentication-------------------------
module.exports.isAuthenticated = async (req, res, next) => {
    var refreshToken = null
    var accessToken = null
    if(req.session.passport){
        if(req.session.passport.user && req.session.passport.user.accessToken && req.session.passport.user.refreshToken){
            var refreshToken =  req.session.passport.user.refreshToken;
            var accessToken = req.session.passport.user.accessToken
        }else{
            req.session.destroy((err) => {
                if (err) {
                    console.error('Error destroying session:', err);

                }
                res.clearCookie('v_r_dev'); // کوکی سشن را پاک می‌کند

            });
            res.redirect("/login")
        }
    }else{
        if (req.session.user == null) {
            res.redirect("/login")
        }else{
            var refreshToken =  req.session.user.refreshToken;
            var accessToken = req.session.user.accessToken
        }
    }

    if(refreshToken==null || accessToken==null){
        res.redirect("/login")
    }

    jwt.verify(accessToken,process.env.ACCESS_TOKEN_SECRET, async (err, authData) => {
        if (err) {

            jwt.verify(refreshToken, process.env.REFRESH_TOKEN_SECRET, async (err, user) => {
                if (err) {
                    res.redirect("/login")
                }

               if(req.session.user){
                    jwt.sign(user, process.env.ACCESS_TOKEN_SECRET,async (err, accessToken1) => {
                        if (err) next(err)
                        req.session.user.accessToken = accessToken1;

                    });
               }
                if(req.session.passport){
                    jwt.sign(user, process.env.ACCESS_TOKEN_SECRET,async (err, accessToken1) => {
                        if (err) next(err)
                        req.session.passport.user.accessToken = accessToken1;

                    });
                }




                req.user = user.user

                next()
            })
        } 
        else {
            req.user = authData.user
            next()
        }
    });

}
//------------------------------Athentication-------------------------
//------------------------------Allow-------------------------
/*
module.exports.isAllowed = async (req, res, next) => {

    var allowed = false
    var url = req.originalUrl.trim().toLowerCase().split("/")

    var role = '/' + url[1] + '/' + url[2] + '/' + url[3]

    console.log("role")
    console.log(role)

    var lan = await Language.findOne({ ShortName: req.params.lan })
    var user = await User.findOne({_id: req.user._id})
    var userType = await UserType.findOne({_id: user.UserType})
        .populate("UserRoles")

    var userRole = await userType.UserRoles.find( a => a.Url == role)

    if(userRole) {
        next()
    } else {
        res.redirect('/' + lan.ShortName + '/product')
    }
}
*/
//------------------------------Allow-------------------------
