//------------- Requires ------------------
const config = require("../config/general")
const connection = config.connection;
const ProductPrice = connection.models.ProductPrice;
const Product = connection.models.Product;
const ProductDocument = connection.models.ProductDocument;
const Item = connection.models.Item;
const File = connection.models.File;
const Currency = connection.models.Currency;
const Size = connection.models.Size;
const Color = connection.models.Color;
const Guarantee = connection.models.Guarantee;
const Price = connection.models.Price;
//------------- Requires ------------------
async function findFactorProductItems(lan, currency, item, callback) {
    var item = await Item.findOne({ _id: item })
    
    var productPrice = await ProductPrice.findOne({ _id: item.Reference })
    var shopProductTypePrice = productPrice.ShopProductTypePrice

    console.log("productPrice.ShopProductTypePrice")
    console.log(productPrice.ShopProductTypePrice)

    var productItem;

    switch (true) {
        case shopProductTypePrice.includes("Color") && shopProductTypePrice.includes("Size") && shopProductTypePrice.includes("Guarantee"):
            console.log("Color Size Guarantee")
            productItem = await Item.aggregate([
                { $match: { Removed: false, _id: item._id } },
                //----------------------------- populate ProductPrice as ProductPriceDetail start
                { $lookup: {from: 'productprices', localField: 'Reference', foreignField: '_id', as: 'ProductPriceDetail'} },
                { $unwind: '$ProductPriceDetail'},
                //----------------------------- populate ProductPrice as ProductPriceDetail end
                //----------------------------- populate Color as ColorDetail start
                { $lookup: {from: 'colors', localField: 'ProductPriceDetail.Color', foreignField: '_id', as: 'ColorDetail'} },
                { $unwind: '$ColorDetail'},
                //----------------------------- populate Color as ColorDetail end
                //----------------------------- populate Color as ColorDocument start
                { $unwind: '$ColorDetail.Documents'},
                { $match: {"ColorDetail.Documents.Language": lan}},
                { $lookup: {from: 'colordocuments', localField: 'ColorDetail.Documents.Document', foreignField: '_id', as: 'ColorDocument'} },
                { $unwind: '$ColorDocument'},
                //----------------------------- populate Color as ColorDocument end
                //----------------------------- populate Size as SizeDetail start
                { $lookup: {from: 'sizes', localField: 'ProductPriceDetail.Size', foreignField: '_id', as: 'SizeDetail'} },
                { $unwind: '$SizeDetail'},
                //----------------------------- populate Size as SizeDetail end
                //----------------------------- populate Size as SizeDocument start
                { $unwind: '$SizeDetail.Documents'},
                { $match: {"SizeDetail.Documents.Language": lan}},
                { $lookup: {from: 'sizedocuments', localField: 'SizeDetail.Documents.Document', foreignField: '_id', as: 'SizeDocument'} },
                { $unwind: '$SizeDocument'},
                //----------------------------- populate Size as SizeDocument end
                //----------------------------- populate Guarantee as GuaranteeDetail start
                { $lookup: {from: 'guarantees', localField: 'ProductPriceDetail.Guarantee', foreignField: '_id', as: 'GuaranteeDetail'} },
                { $unwind: '$GuaranteeDetail'},
                //----------------------------- populate Guarantee as GuaranteeDetail end
                //----------------------------- populate Guarantee as GuaranteeDocument start
                { $unwind: '$GuaranteeDetail.Documents'},
                { $match: {"GuaranteeDetail.Documents.Language": lan}},
                { $lookup: {from: 'guaranteedocuments', localField: 'GuaranteeDetail.Documents.Document', foreignField: '_id', as: 'GuaranteeDocument'} },
                { $unwind: '$GuaranteeDocument'},
                //----------------------------- populate Guarantee as GuaranteeDocument end
                //----------------------------- populate Product as ProductDetail start
                { $lookup: {from: 'products', localField: 'ProductPriceDetail.Product', foreignField: '_id', as: 'ProductDetail'} },
                { $unwind: '$ProductDetail'},
                //----------------------------- populate Product as ProductDetail end
                //----------------------------- populate and find ProductDocument as ProductDocument start
                { $unwind: '$ProductDetail.Documents'},
                { $match: {"ProductDetail.Documents.Language": lan}},
                { $lookup: {from: 'productdocuments', localField: 'ProductDetail.Documents.Document', foreignField: '_id', as: 'ProductDocument'} },
                { $unwind: '$ProductDocument'},
                //----------------------------- populate and find ProductDocument as ProductDocument end
                //----------------------------- populate and find Files as Files start
                { $lookup: {from: 'files', localField: 'ProductDocument.Files', foreignField: '_id', as: 'Files'} },
                { $set: { Files: { $filter: { input: "$Files", cond: { $eq: ["$$this.Removed", false] } } } } },
                //----------------------------- populate and find Files as Files end
                //----------------------------- populate and find LastPrices as LastPrice start
                { $unwind: '$ProductPriceDetail.LastPrices'},
                { $match: {"ProductPriceDetail.LastPrices.Currency": currency}},
                { $lookup: {from: 'prices', localField: 'ProductPriceDetail.LastPrices.Price', foreignField: '_id', as: 'LastPrice'} },
                { $unwind: "$LastPrice"},
                //----------------------------- populate and find LastPrices as LastPrice end
            ])
            break;
        case shopProductTypePrice.includes("Color") && shopProductTypePrice.includes("Size") && !shopProductTypePrice.includes("Guarantee"):
            console.log("Color Size")
            productItem = await Item.aggregate([
                { $match: { Removed: false, _id: item._id } },
                //----------------------------- populate ProductPrice as ProductPriceDetail start
                { $lookup: {from: 'productprices', localField: 'Reference', foreignField: '_id', as: 'ProductPriceDetail'} },
                { $unwind: '$ProductPriceDetail'},
                //----------------------------- populate ProductPrice as ProductPriceDetail end
                //----------------------------- populate Color as ColorDetail start
                { $lookup: {from: 'colors', localField: 'ProductPriceDetail.Color', foreignField: '_id', as: 'ColorDetail'} },
                { $unwind: '$ColorDetail'},
                //----------------------------- populate Color as ColorDetail end
                //----------------------------- populate Color as ColorDocument start
                { $unwind: '$ColorDetail.Documents'},
                { $match: {"ColorDetail.Documents.Language": lan}},
                { $lookup: {from: 'colordocuments', localField: 'ColorDetail.Documents.Document', foreignField: '_id', as: 'ColorDocument'} },
                { $unwind: '$ColorDocument'},
                //----------------------------- populate Color as ColorDocument end
                //----------------------------- populate Size as SizeDetail start
                { $lookup: {from: 'sizes', localField: 'ProductPriceDetail.Size', foreignField: '_id', as: 'SizeDetail'} },
                { $unwind: '$SizeDetail'},
                //----------------------------- populate Size as SizeDetail end
                //----------------------------- populate Size as SizeDocument start
                { $unwind: '$SizeDetail.Documents'},
                { $match: {"SizeDetail.Documents.Language": lan}},
                { $lookup: {from: 'sizedocuments', localField: 'SizeDetail.Documents.Document', foreignField: '_id', as: 'SizeDocument'} },
                { $unwind: '$SizeDocument'},
                //----------------------------- populate Size as SizeDocument end
                //----------------------------- populate Product as ProductDetail start
                { $lookup: {from: 'products', localField: 'ProductPriceDetail.Product', foreignField: '_id', as: 'ProductDetail'} },
                { $unwind: '$ProductDetail'},
                //----------------------------- populate Product as ProductDetail end
                //----------------------------- populate and find ProductDocument as ProductDocument start
                { $unwind: '$ProductDetail.Documents'},
                { $match: {"ProductDetail.Documents.Language": lan}},
                { $lookup: {from: 'productdocuments', localField: 'ProductDetail.Documents.Document', foreignField: '_id', as: 'ProductDocument'} },
                { $unwind: '$ProductDocument'},
                //----------------------------- populate and find ProductDocument as ProductDocument end
                //----------------------------- populate and find Files as Files start
                { $lookup: {from: 'files', localField: 'ProductDocument.Files', foreignField: '_id', as: 'Files'} },
                { $set: { Files: { $filter: { input: "$Files", cond: { $eq: ["$$this.Removed", false] } } } } },
                //----------------------------- populate and find Files as Files end
                //----------------------------- populate and find LastPrices as LastPrice start
                { $unwind: '$ProductPriceDetail.LastPrices'},
                { $match: {"ProductPriceDetail.LastPrices.Currency": currency}},
                { $lookup: {from: 'prices', localField: 'ProductPriceDetail.LastPrices.Price', foreignField: '_id', as: 'LastPrice'} },
                { $unwind: "$LastPrice"},
                //----------------------------- populate and find LastPrices as LastPrice end
            ])
            break;
        case shopProductTypePrice.includes("Color") && !shopProductTypePrice.includes("Size") && shopProductTypePrice.includes("Guarantee"):
            console.log("Color Guarantee")
            productItem = await Item.aggregate([
                { $match: { Removed: false, _id: item._id } },
                //----------------------------- populate ProductPrice as ProductPriceDetail start
                { $lookup: {from: 'productprices', localField: 'Reference', foreignField: '_id', as: 'ProductPriceDetail'} },
                { $unwind: '$ProductPriceDetail'},
                //----------------------------- populate ProductPrice as ProductPriceDetail end
                //----------------------------- populate Color as ColorDetail start
                { $lookup: {from: 'colors', localField: 'ProductPriceDetail.Color', foreignField: '_id', as: 'ColorDetail'} },
                { $unwind: '$ColorDetail'},
                //----------------------------- populate Color as ColorDetail end
                //----------------------------- populate Color as ColorDocument start
                { $unwind: '$ColorDetail.Documents'},
                { $match: {"ColorDetail.Documents.Language": lan}},
                { $lookup: {from: 'colordocuments', localField: 'ColorDetail.Documents.Document', foreignField: '_id', as: 'ColorDocument'} },
                { $unwind: '$ColorDocument'},
                //----------------------------- populate Color as ColorDocument end
                //----------------------------- populate Guarantee as GuaranteeDetail start
                { $lookup: {from: 'guarantees', localField: 'ProductPriceDetail.Guarantee', foreignField: '_id', as: 'GuaranteeDetail'} },
                { $unwind: '$GuaranteeDetail'},
                //----------------------------- populate Guarantee as GuaranteeDetail end
                //----------------------------- populate Guarantee as GuaranteeDocument start
                { $unwind: '$GuaranteeDetail.Documents'},
                { $match: {"GuaranteeDetail.Documents.Language": lan}},
                { $lookup: {from: 'guaranteedocuments', localField: 'GuaranteeDetail.Documents.Document', foreignField: '_id', as: 'GuaranteeDocument'} },
                { $unwind: '$GuaranteeDocument'},
                //----------------------------- populate Guarantee as GuaranteeDocument end
                //----------------------------- populate Product as ProductDetail start
                { $lookup: {from: 'products', localField: 'ProductPriceDetail.Product', foreignField: '_id', as: 'ProductDetail'} },
                { $unwind: '$ProductDetail'},
                //----------------------------- populate Product as ProductDetail end
                //----------------------------- populate and find ProductDocument as ProductDocument start
                { $unwind: '$ProductDetail.Documents'},
                { $match: {"ProductDetail.Documents.Language": lan}},
                { $lookup: {from: 'productdocuments', localField: 'ProductDetail.Documents.Document', foreignField: '_id', as: 'ProductDocument'} },
                { $unwind: '$ProductDocument'},
                //----------------------------- populate and find ProductDocument as ProductDocument end
                //----------------------------- populate and find Files as Files start
                { $lookup: {from: 'files', localField: 'ProductDocument.Files', foreignField: '_id', as: 'Files'} },
                { $set: { Files: { $filter: { input: "$Files", cond: { $eq: ["$$this.Removed", false] } } } } },
                //----------------------------- populate and find Files as Files end
                //----------------------------- populate and find LastPrices as LastPrice start
                { $unwind: '$ProductPriceDetail.LastPrices'},
                { $match: {"ProductPriceDetail.LastPrices.Currency": currency}},
                { $lookup: {from: 'prices', localField: 'ProductPriceDetail.LastPrices.Price', foreignField: '_id', as: 'LastPrice'} },
                { $unwind: "$LastPrice"},
                //----------------------------- populate and find LastPrices as LastPrice end
            ])
            break;
        case !shopProductTypePrice.includes("Color") && shopProductTypePrice.includes("Size") && shopProductTypePrice.includes("Guarantee"):
            console.log("Size Guarantee")
            productItem = await Item.aggregate([
                { $match: { Removed: false, _id: item._id } },
                //----------------------------- populate ProductPrice as ProductPriceDetail start
                { $lookup: {from: 'productprices', localField: 'Reference', foreignField: '_id', as: 'ProductPriceDetail'} },
                { $unwind: '$ProductPriceDetail'},
                //----------------------------- populate ProductPrice as ProductPriceDetail end
                //----------------------------- populate Size as SizeDetail start
                { $lookup: {from: 'sizes', localField: 'ProductPriceDetail.Size', foreignField: '_id', as: 'SizeDetail'} },
                { $unwind: '$SizeDetail'},
                //----------------------------- populate Size as SizeDetail end
                //----------------------------- populate Size as SizeDocument start
                { $unwind: '$SizeDetail.Documents'},
                { $match: {"SizeDetail.Documents.Language": lan}},
                { $lookup: {from: 'sizedocuments', localField: 'SizeDetail.Documents.Document', foreignField: '_id', as: 'SizeDocument'} },
                { $unwind: '$SizeDocument'},
                //----------------------------- populate Size as SizeDocument end
                //----------------------------- populate Guarantee as GuaranteeDetail start
                { $lookup: {from: 'guarantees', localField: 'ProductPriceDetail.Guarantee', foreignField: '_id', as: 'GuaranteeDetail'} },
                { $unwind: '$GuaranteeDetail'},
                //----------------------------- populate Guarantee as GuaranteeDetail end
                //----------------------------- populate Guarantee as GuaranteeDocument start
                { $unwind: '$GuaranteeDetail.Documents'},
                { $match: {"GuaranteeDetail.Documents.Language": lan}},
                { $lookup: {from: 'guaranteedocuments', localField: 'GuaranteeDetail.Documents.Document', foreignField: '_id', as: 'GuaranteeDocument'} },
                { $unwind: '$GuaranteeDocument'},
                //----------------------------- populate Guarantee as GuaranteeDocument end
                //----------------------------- populate Product as ProductDetail start
                { $lookup: {from: 'products', localField: 'ProductPriceDetail.Product', foreignField: '_id', as: 'ProductDetail'} },
                { $unwind: '$ProductDetail'},
                //----------------------------- populate Product as ProductDetail end
                //----------------------------- populate and find ProductDocument as ProductDocument start
                { $unwind: '$ProductDetail.Documents'},
                { $match: {"ProductDetail.Documents.Language": lan}},
                { $lookup: {from: 'productdocuments', localField: 'ProductDetail.Documents.Document', foreignField: '_id', as: 'ProductDocument'} },
                { $unwind: '$ProductDocument'},
                //----------------------------- populate and find ProductDocument as ProductDocument end
                //----------------------------- populate and find Files as Files start
                { $lookup: {from: 'files', localField: 'ProductDocument.Files', foreignField: '_id', as: 'Files'} },
                { $set: { Files: { $filter: { input: "$Files", cond: { $eq: ["$$this.Removed", false] } } } } },
                //----------------------------- populate and find Files as Files end
                //----------------------------- populate and find LastPrices as LastPrice start
                { $unwind: '$ProductPriceDetail.LastPrices'},
                { $match: {"ProductPriceDetail.LastPrices.Currency": currency}},
                { $lookup: {from: 'prices', localField: 'ProductPriceDetail.LastPrices.Price', foreignField: '_id', as: 'LastPrice'} },
                { $unwind: "$LastPrice"},
                //----------------------------- populate and find LastPrices as LastPrice end
            ])
            break;
        case shopProductTypePrice.includes("Color") && !shopProductTypePrice.includes("Size") && !shopProductTypePrice.includes("Guarantee"):
            console.log("Color")
            productItem = await Item.aggregate([
                { $match: { Removed: false, _id: item._id } },
                //----------------------------- populate ProductPrice as ProductPriceDetail start
                { $lookup: {from: 'productprices', localField: 'Reference', foreignField: '_id', as: 'ProductPriceDetail'} },
                { $unwind: '$ProductPriceDetail'},
                //----------------------------- populate ProductPrice as ProductPriceDetail end
                //----------------------------- populate Color as ColorDetail start
                { $lookup: {from: 'colors', localField: 'ProductPriceDetail.Color', foreignField: '_id', as: 'ColorDetail'} },
                { $unwind: '$ColorDetail'},
                //----------------------------- populate Color as ColorDetail end
                //----------------------------- populate Color as ColorDocument start
                { $unwind: '$ColorDetail.Documents'},
                { $match: {"ColorDetail.Documents.Language": lan}},
                { $lookup: {from: 'colordocuments', localField: 'ColorDetail.Documents.Document', foreignField: '_id', as: 'ColorDocument'} },
                { $unwind: '$ColorDocument'},
                //----------------------------- populate Color as ColorDocument end
                //----------------------------- populate Product as ProductDetail start
                { $lookup: {from: 'products', localField: 'ProductPriceDetail.Product', foreignField: '_id', as: 'ProductDetail'} },
                { $unwind: '$ProductDetail'},
                //----------------------------- populate Product as ProductDetail end
                //----------------------------- populate and find ProductDocument as ProductDocument start
                { $unwind: '$ProductDetail.Documents'},
                { $match: {"ProductDetail.Documents.Language": lan}},
                { $lookup: {from: 'productdocuments', localField: 'ProductDetail.Documents.Document', foreignField: '_id', as: 'ProductDocument'} },
                { $unwind: '$ProductDocument'},
                //----------------------------- populate and find ProductDocument as ProductDocument end
                //----------------------------- populate and find Files as Files start
                { $lookup: {from: 'files', localField: 'ProductDocument.Files', foreignField: '_id', as: 'Files'} },
                { $set: { Files: { $filter: { input: "$Files", cond: { $eq: ["$$this.Removed", false] } } } } },
                //----------------------------- populate and find Files as Files end
                //----------------------------- populate and find LastPrices as LastPrice start
                { $unwind: '$ProductPriceDetail.LastPrices'},
                { $match: {"ProductPriceDetail.LastPrices.Currency": currency}},
                { $lookup: {from: 'prices', localField: 'ProductPriceDetail.LastPrices.Price', foreignField: '_id', as: 'LastPrice'} },
                { $unwind: "$LastPrice"},
                //----------------------------- populate and find LastPrices as LastPrice end
            ])
            break;
        case !shopProductTypePrice.includes("Color") && shopProductTypePrice.includes("Size") && !shopProductTypePrice.includes("Guarantee"):
            console.log("Size")
            productItem = await Item.aggregate([
                { $match: { Removed: false, _id: item._id } },
                //----------------------------- populate ProductPrice as ProductPriceDetail start
                { $lookup: {from: 'productprices', localField: 'Reference', foreignField: '_id', as: 'ProductPriceDetail'} },
                { $unwind: '$ProductPriceDetail'},
                //----------------------------- populate ProductPrice as ProductPriceDetail end
                //----------------------------- populate Size as SizeDetail start
                { $lookup: {from: 'sizes', localField: 'ProductPriceDetail.Size', foreignField: '_id', as: 'SizeDetail'} },
                { $unwind: '$SizeDetail'},
                //----------------------------- populate Size as SizeDetail end
                //----------------------------- populate Size as SizeDocument start
                { $unwind: '$SizeDetail.Documents'},
                { $match: {"SizeDetail.Documents.Language": lan}},
                { $lookup: {from: 'sizedocuments', localField: 'SizeDetail.Documents.Document', foreignField: '_id', as: 'SizeDocument'} },
                { $unwind: '$SizeDocument'},
                //----------------------------- populate Size as SizeDocument end
                //----------------------------- populate Product as ProductDetail start
                { $lookup: {from: 'products', localField: 'ProductPriceDetail.Product', foreignField: '_id', as: 'ProductDetail'} },
                { $unwind: '$ProductDetail'},
                //----------------------------- populate Product as ProductDetail end
                //----------------------------- populate and find ProductDocument as ProductDocument start
                { $unwind: '$ProductDetail.Documents'},
                { $match: {"ProductDetail.Documents.Language": lan}},
                { $lookup: {from: 'productdocuments', localField: 'ProductDetail.Documents.Document', foreignField: '_id', as: 'ProductDocument'} },
                { $unwind: '$ProductDocument'},
                //----------------------------- populate and find ProductDocument as ProductDocument end
                //----------------------------- populate and find Files as Files start
                { $lookup: {from: 'files', localField: 'ProductDocument.Files', foreignField: '_id', as: 'Files'} },
                { $set: { Files: { $filter: { input: "$Files", cond: { $eq: ["$$this.Removed", false] } } } } },
                //----------------------------- populate and find Files as Files end
                //----------------------------- populate and find LastPrices as LastPrice start
                { $unwind: '$ProductPriceDetail.LastPrices'},
                { $match: {"ProductPriceDetail.LastPrices.Currency": currency}},
                { $lookup: {from: 'prices', localField: 'ProductPriceDetail.LastPrices.Price', foreignField: '_id', as: 'LastPrice'} },
                { $unwind: "$LastPrice"},
                //----------------------------- populate and find LastPrices as LastPrice end
            ])
            break;
        case !shopProductTypePrice.includes("Color") && !shopProductTypePrice.includes("Size") && shopProductTypePrice.includes("Guarantee"):
            console.log("Guarantee")
            productItem = await Item.aggregate([
                { $match: { Removed: false, _id: item._id } },
                //----------------------------- populate ProductPrice as ProductPriceDetail start
                { $lookup: {from: 'productprices', localField: 'Reference', foreignField: '_id', as: 'ProductPriceDetail'} },
                { $unwind: '$ProductPriceDetail'},
                //----------------------------- populate ProductPrice as ProductPriceDetail end
                //----------------------------- populate Guarantee as GuaranteeDetail start
                { $lookup: {from: 'guarantees', localField: 'ProductPriceDetail.Guarantee', foreignField: '_id', as: 'GuaranteeDetail'} },
                { $unwind: '$GuaranteeDetail'},
                //----------------------------- populate Guarantee as GuaranteeDetail end
                //----------------------------- populate Guarantee as GuaranteeDocument start
                { $unwind: '$GuaranteeDetail.Documents'},
                { $match: {"GuaranteeDetail.Documents.Language": lan}},
                { $lookup: {from: 'guaranteedocuments', localField: 'GuaranteeDetail.Documents.Document', foreignField: '_id', as: 'GuaranteeDocument'} },
                { $unwind: '$GuaranteeDocument'},
                //----------------------------- populate Guarantee as GuaranteeDocument end
                //----------------------------- populate Product as ProductDetail start
                { $lookup: {from: 'products', localField: 'ProductPriceDetail.Product', foreignField: '_id', as: 'ProductDetail'} },
                { $unwind: '$ProductDetail'},
                //----------------------------- populate Product as ProductDetail end
                //----------------------------- populate and find ProductDocument as ProductDocument start
                { $unwind: '$ProductDetail.Documents'},
                { $match: {"ProductDetail.Documents.Language": lan}},
                { $lookup: {from: 'productdocuments', localField: 'ProductDetail.Documents.Document', foreignField: '_id', as: 'ProductDocument'} },
                { $unwind: '$ProductDocument'},
                //----------------------------- populate and find ProductDocument as ProductDocument end
                //----------------------------- populate and find Files as Files start
                { $lookup: {from: 'files', localField: 'ProductDocument.Files', foreignField: '_id', as: 'Files'} },
                { $set: { Files: { $filter: { input: "$Files", cond: { $eq: ["$$this.Removed", false] } } } } },
                //----------------------------- populate and find Files as Files end
                //----------------------------- populate and find LastPrices as LastPrice start
                { $unwind: '$ProductPriceDetail.LastPrices'},
                { $match: {"ProductPriceDetail.LastPrices.Currency": currency}},
                { $lookup: {from: 'prices', localField: 'ProductPriceDetail.LastPrices.Price', foreignField: '_id', as: 'LastPrice'} },
                { $unwind: "$LastPrice"},
                //----------------------------- populate and find LastPrices as LastPrice end
            ])
            break;
        case !shopProductTypePrice.includes("Color") && !shopProductTypePrice.includes("Size") && !shopProductTypePrice.includes("Guarantee"):
            console.log("not any")
            console.log("item._id")
            console.log(item._id)
            productItem = await Item.aggregate([
                { $match: { Removed: false, _id: item._id } },
                //----------------------------- populate ProductPrice as ProductPriceDetail start
                { $lookup: {from: 'productprices', localField: 'Reference', foreignField: '_id', as: 'ProductPriceDetail'} },
                { $unwind: '$ProductPriceDetail'},
                //----------------------------- populate ProductPrice as ProductPriceDetail end
                //----------------------------- populate Product as ProductDetail start
                { $lookup: {from: 'products', localField: 'ProductPriceDetail.Product', foreignField: '_id', as: 'ProductDetail'} },
                { $unwind: '$ProductDetail'},
                //----------------------------- populate Product as ProductDetail end
                //----------------------------- populate and find ProductDocument as ProductDocument start
                { $unwind: '$ProductDetail.Documents'},
                { $match: {"ProductDetail.Documents.Language": lan}},
                { $lookup: {from: 'productdocuments', localField: 'ProductDetail.Documents.Document', foreignField: '_id', as: 'ProductDocument'} },
                { $unwind: '$ProductDocument'},
                //----------------------------- populate and find ProductDocument as ProductDocument end
                //----------------------------- populate and find Files as Files start
                { $lookup: {from: 'files', localField: 'ProductDocument.Files', foreignField: '_id', as: 'Files'} },
                { $set: { Files: { $filter: { input: "$Files", cond: { $eq: ["$$this.Removed", false] } } } } },
                //----------------------------- populate and find Files as Files end
                // //----------------------------- populate and find LastPrices as LastPrice start
                // { $unwind: '$ProductPriceDetail.LastPrices'},
                // { $match: {"ProductPriceDetail.LastPrices.Currency": currency}},
                // { $lookup: {from: 'prices', localField: 'ProductPriceDetail.LastPrices.Price', foreignField: '_id', as: 'LastPrice'} },
                // { $unwind: "$LastPrice"},
                // //----------------------------- populate and find LastPrices as LastPrice end
            ])
            break;
        default:
            console.log("non")
    }

    if(callback){
        callback(productItem);
        return productItem;
    }
}

async function setFactorItems(itemsId, lan, currency, callback){
    var productItems = []
    var singleItem;
    var totalPrice = 0

    if(itemsId.length == 0) {
        productItems = []
        totalPrice = 0

        callback(productItems, totalPrice);
        return productItems;
    } else {
        var promise = new Promise(async function (resolve, reject) {
            await itemsId.forEach(async (item) => {
                // await productItems.push(await findFactorProductItems(currency._id, lan._id, item))
                await findFactorProductItems(lan, currency, item, async function (result) {
                    singleItem = await result[0]
                    console.log("singleItem")
                    console.log(singleItem)
                    totalPrice = await totalPrice + singleItem.Price * singleItem.Number
                    await productItems.push(singleItem)
                    console.log("productItems2")
                    console.log(productItems)
                    if(itemsId.length == productItems.length){
                        resolve()
                    }
                })
            })
        })

        Promise.all([promise]).then(async function (){
            if(callback){
                console.log("productItems")
                console.log(productItems)

                callback(productItems, totalPrice);
                return productItems;
            }
        })
    }
}
//----------------------------------------exports
module.exports.setFactorItems = setFactorItems;
module.exports.findFactorProductItems = findFactorProductItems;