//------------- Requires ------------------
//------------- Requires ------------------
const config = require("../../config/general")

const express = config.express;
const router = express.Router({mergeParams: true});
const personnelControllers = require('../../controllers/admin/index')
const authentication = require("../../lib/authFunctions");
const permistions = require("../../lib/permistions");

//----------------------------------------------------------------------
//------------------------------user--------------------------
router.get("/user/list",authentication.isAuthenticated,permistions.checkPermision('list-users'),personnelControllers.getAddUser);
router.post("/user/add",authentication.isAuthenticated,permistions.checkPermision('add-users'),personnelControllers.postAddUser);
router.get("/user/edit/:id",authentication.isAuthenticated,permistions.checkPermision('edit-users'),personnelControllers.getEditUser);
router.post("/user/edit/:id",authentication.isAuthenticated,permistions.checkPermision('edit-users'),personnelControllers.postEditUser);
router.get("/user/remove/:id",authentication.isAuthenticated,permistions.checkPermision('delete-users'),personnelControllers.postRemoveUser);

//------------------------------user---------------------------

//------------------------------usertype--------------------------
router.get("/usertype/list",authentication.isAuthenticated,permistions.checkPermision('list-usertype'),personnelControllers.getAddUserType);
router.post("/usertype/add",authentication.isAuthenticated,permistions.checkPermision('add-usertype'),personnelControllers.postAddUserType);
router.get("/usertype/edit/:id",authentication.isAuthenticated,permistions.checkPermision('edit-usertype'),personnelControllers.getEditUserType);
router.post("/usertype/edit/:id",authentication.isAuthenticated,permistions.checkPermision('edit-usertype'),personnelControllers.postEditUserType);
router.get("/usertype/remove/:id",authentication.isAuthenticated,permistions.checkPermision('delete-usertype'),personnelControllers.postRemoveUserType);

//------------------------------usertype---------------------------


//------------------------------usertype--------------------------
router.get("/permision/list",authentication.isAuthenticated,permistions.checkPermision('list-permision'),personnelControllers.getAddPermision);
router.post("/permision/add",authentication.isAuthenticated,permistions.checkPermision('add-permision'),personnelControllers.postAddPermision);
router.get("/permision/edit/:id",authentication.isAuthenticated,permistions.checkPermision('edit-permision'),personnelControllers.getEditPermision);
router.post("/permision/edit/:id",authentication.isAuthenticated,permistions.checkPermision('edit-permision'),personnelControllers.postEditPermision);
router.get("/permision/remove/:id",authentication.isAuthenticated,permistions.checkPermision('edit-permision'),personnelControllers.postRemovePermision);


//------------------------------usertype---------------------------

router.get("/setting",authentication.isAuthenticated,personnelControllers.getSetting);
router.post("/setting",authentication.isAuthenticated,personnelControllers.postSetting);

router.get("/logout",authentication.isAuthenticated,personnelControllers.getLogOut);

module.exports = router;