//------------- Requires ------------------
const generateSystemLog = require('../../lib/systemLog').generateSystemLog;
const generateMessage = require('../../lib/flashMessage').generateMessage;
const generateDate = require('../../lib/publicFunctions').generateDate;
const createFolder = require('../../lib/uploadFileFTP').createFolder;
const report = require('../../lib/report').setReport;
const config = require("../../config/general");
const connection = config.connection;
const User=connection.models.User;
const File=connection.models.File;
require('dotenv').config({path: './.env'});
const jwt = require('jsonwebtoken')
const bcrypt=config.bcrypt;
const fs = require("fs");

//------------- Requires ------------------
//----------------------------------------------------------------------admin
//------------------------------List----------------------------


exports.index = async (req, res) => {
    var user = await User.findOne({_id:req.user._id}).populate('Image')
    console.log(req.session)
    console.log(req.user)
    console.log(req.flash('account_error'))
    res.render("account/account",{
        user
    })
};
exports.postEditUser =async (req,res)=>{
    var user = await User.findOne({_id:req.user._id})
    if(!user) {

        req.flash('account_error',{ message: 'user not found' });
        return res.redirect('/account');

    }
    const {FirstName, LastName, Email} = req.body;

    if(!Email){
        req.flash('account_error',{ message: 'Email inpute in empty' });
        return res.redirect('/account'); // توقف اجرای کد

    }
    if(!FirstName){

        req.flash('register_error',{ message: 'FirtName inpute in empty' });
        return res.redirect('/register'); // توقف اجرای کد
    }
    if(!LastName){

        req.flash('account_error',{ message: 'LastName inpute in empty' });
        return res.redirect('/account');
    }

    let find = await User.findOne({
        Email:Email,
    })
    if(find && find.Email != user.Email){
        req.flash('account_error',{ message: 'Email is already in use' });
        return res.redirect('/account');
    }

    const updateResult = await User.updateOne( // await را اضافه کنید
        { _id: user._id },
        { $set: {
                Name: FirstName,
                LastName:LastName,
                Email:Email,

            }
        }
    );

    if (updateResult.modifiedCount === 0) {
        req.flash('account_error',{ message: 'Failed to edit user' });
        return res.redirect('/account');
    }

    req.flash('account_error',{message: "edit user is seccessfully"});
    return res.redirect('/account');
}

exports.PostEditPassUser = async (req,res)=>{
    var user = await User.findOne({_id:req.user._id})
    const {CurrentPassword,Password, confirmPassword } = req.body;
    if(!Password){
        req.flash('account_error',{ message: 'Password inpute in empty' });
        return res.redirect('/account');
    }
    if(!confirmPassword){
        req.flash('account_error',{ message: 'confirmPassword inpute in empty' });
        return res.redirect('/account');
    }
    // 2. بررسی تطابق password و confirmPassword
    if (Password !== confirmPassword) {
        req.flash('account_error',{ message: 'Passwords do not match' });
        return res.redirect('/account');
    }
    const isMatch = await bcrypt.compare(CurrentPassword, user.Password);
    if (!isMatch) {
        req.flash('account_error', { message: 'The password is wrong' });
        return res.redirect('/account'); // توقف اجرای کد
    }
    const hashedPassword = await bcrypt.hash(Password, 10);
    const updateResult = await User.updateOne( // await را اضافه کنید
        { _id: user._id },
        { $set: { Password: hashedPassword } }
    );
    if (updateResult.modifiedCount === 0) {
        req.flash('account_error',{ message: 'user not found or password not changed.' });
        return res.redirect('/account');
    }
    req.flash('account_success',{ message: 'The password was changed successfully' });
    return res.redirect('/account');

}


exports.PostEditAvatar = async (req, res) => {
    try {
        var user = await User.findOne({ _id: req.user._id }).populate('Image');

        if (!user) {
            req.flash('account', { type: "error", message: 'کاربر یافت نشد' });
            return res.redirect('/account');
        }

        // حذف فایل قبلی
        if (user.Image) {
            const filePath = 'assets/' + user.Image.Url;
            try {
                await fs.promises.unlink(filePath);
                console.log("فایل با موفقیت حذف شد.");
            } catch (err) {
                console.error("خطا در حذف فایل:", err);
            }

            // حذف از دیتابیس
            const deleteResult = await File.deleteOne({ _id: user.Image._id });
            if (deleteResult.deletedCount === 0) {
                console.log("فایلی برای حذف یافت نشد.");
            }
        }

        // بررسی وجود فایل جدید
        if (!req.file) {
            req.flash('account', { type: "error", message: 'لطفاً یک تصویر آپلود کنید' });
            return res.redirect('/account');
        }

        // ذخیره فایل جدید
        let fileData = new File({
            Name: req.file.filename,
            Alt: null,
            SmallCaption: null,
            Caption: null,
            Type: 0, // تصویر
            Url: `/upload/images/avatar/${req.file.filename}`,
            PersianDate: {
                Add: new Date(),
                LastUpdate: new Date(),
            },
            Status: 1,
        });

        await fileData.save();

        // به‌روزرسانی اطلاعات کاربر
        const updateResult = await User.updateOne(
            { _id: user._id },
            { $set: { Image: fileData._id } }
        );

        if (updateResult.modifiedCount > 0) {
            req.flash('account', { type: "success", message: 'آواتار تغییر کرد' });
        } else {
            console.log("هیچ تغییری در کاربر ایجاد نشد.");
        }

        return res.redirect('/account');
    } catch (e) {
        console.error("خطا در تغییر آواتار:", e);
        req.flash('account', { type: "error", message: 'مشکلی در تغییر آواتار پیش آمد.' });
        return res.redirect('/account');
    }
};
