//------------- Requires ------------------
const generateSystemLog = require('../../lib/systemLog').generateSystemLog;
const generateMessage = require('../../lib/flashMessage').generateMessage;
const generateDate = require('../../lib/publicFunctions').generateDate;
const config = require("../../config/general");
const connection = config.connection;
const User = connection.models.User;
const UserType = connection.models.UserType;
const Permision = connection.models.Permision;
const Setting = connection.models.Setting;
require('dotenv').config({path: './.env'});
const jwt = require('jsonwebtoken')
const bcrypt=config.bcrypt;


//------------- Requires ------------------
//----------------------------------------------------------------------admin
//------------------------------user----------------------------
exports.getAddUser=async(req,res)=>{
    var useradmin =await User.findOne({_id:req.user._id});
    var users = await User.find().populate('UserType')
    var userTypes = await UserType.find()
    res.render('admin/user/list',{
        useradmin,
        users,
        userTypes
    })
}
exports.postAddUser = async(req,res)=>{

    var newUser = new User({
        Name:req.body.Name,
        LastName:req.body.LastName,
        UserName:req.body.UserName,
        Password:req.body.Password,
        Phone:req.body.Phone,
        Email:req.body.Email,
        UserType:req.body.UserType
    })
    await newUser.save(async function(err,result){
        if(err){
            console.log(err)
        }else{
            console.log(result)
            res.redirect(req.get('referer'))
        }
    })
}
exports.getEditUser=async(req,res)=>{
    var useradmin =await User.findOne({_id:req.user._id});
    var user = await User.findOne({_id:req.params.id}).populate('UserType')
    var userTypes = await UserType.find()
    res.render('admin/user/edit',{
        useradmin,
        user,
        userTypes
    })
}
exports.postEditUser=async(req,res)=>{
    console.log(req.body)
    var user = await User.findOne({_id:req.params.id})
    console.log(user)
    if(req.body.Password==''){
        var newPassword=user.Password
    }
   if(req.body.Password){
        var Password= req.body.Password;
        var  newPassword =Password
    }

await User.updateOne(
        {_id:user._id},
        {$set:{
            Name:req.body.Name,
            LastName:req.body.LastName,
            UserName:req.body.UserName,
            Password: newPassword,
            Phone:req.body.Phone,
            Email:req.body.Email,
            UserType:req.body.UserType
        }},
    function(err,docs){
        if(err){
            console.log(err)
        }else{
            res.redirect(req.get('referer'));
        }
    }
        )
        

}
exports.postRemoveUser=async(req,res)=>{
    var user = await User.findOne({_id:req.params.id})
    await User.findOneAndRemove({_id:user._id}, function(err){
        if(err){
            console.log(err)
        }else{
            res.redirect(req.get('referer'))
        }
    });


}

//-------------------------------------userType--------------------------------------------------
exports.getAddUserType=async(req,res)=>{
    var useradmin =await User.findOne({_id:req.user._id});
    var userTypes = await UserType.find().populate('Permisions')
    var permisions=await Permision.find()
    console.log(permisions)
    res.render('admin/userType/list',{
        useradmin,
        userTypes,
        permisions
    })
}
exports.postAddUserType = async(req,res)=>{


    var newUserType = new UserType({
        Title:req.body.Title,	
        Permisions:req.body.Permisions,
    })
    await newUserType.save(async function(err,result){
        if(err){
            console.log(err)
        }else{
            console.log(result)
            res.redirect(req.get('referer'))
        }
    })
}
exports.getEditUserType=async(req,res)=>{
    var useradmin =await User.findOne({_id:req.user._id});
    var userType = await UserType.findOne({_id:req.params.id})
    var permisions=await Permision.find()
    console.log(permisions)
    res.render('admin/userType/edit',{
        useradmin,
        userType,
        permisions
    })
}
exports.postEditUserType = async(req,res)=>{
    var userType = await UserType.findOne({_id:req.params.id})
    await UserType.updateOne(
        {_id:userType._id},
        {$set:{
            Title:req.body.Title,	
            Permisions:req.body.Permisions,
        }},
        function(err,docs){
            if(err){
                console.log(err)
            }else{
                res.redirect(req.get('referer'));
            }
        }
        
    )

    
}
exports.postRemoveUserType = async(req,res)=>{
    var userType = await UserType.findOne({_id:req.params.id})
    await User.updateMany(
        {UserType:userType._id},
        {
            $set : {
                UserType:null
            }
        },
        function(err,docs){
            if(err){
                console.log(err)
            }
      
        }
    )
    await UserType.findOneAndRemove({_id:userType._id}, function(err){
        if(err){
            console.log(err)
        }else{
           res.redirect(req.get('referer')) 
        }
    });

    
}
//-------------------------------------permision--------------------------------------------------

exports.getAddPermision=async(req,res)=>{
    var useradmin =await User.findOne({_id:req.user._id});
    var permisions = await Permision.find()
    res.render('admin/permision/list',{
        useradmin,
       permisions
    })
}
exports.postAddPermision = async(req,res)=>{
    var newPermision = new Permision({
        Name:req.body.Name,
        Code:req.body.Code
    })
    await newPermision.save(async function(err,result){
        if(err){
            console.log(err)
        }else{
            console.log(result)
            res.redirect(req.get('referer'))
        }
    })
}
exports.getEditPermision=async(req,res)=>{
    var useradmin =await User.findOne({_id:req.user._id});

    var permision = await Permision.findOne({_id:req.params.id})
    res.render('admin/permision/edit',{
        useradmin,
       permision
    })
}
exports.postEditPermision = async(req,res)=>{
    var permision = await Permision.findOne({_id:req.params.id})
    await Permision.updateOne(
        {_id:permision._id},
        {$set:{
            Name:req.body.Name,
            Code:req.body.Code
        }},
        function(err,docs){
            if(err){
                console.log(err)
            }else{
                res.redirect(req.get('referer'));
            }
        }
        
    )

    
}
exports.postRemovePermision = async(req,res)=>{
    var permision= await Permision.findOne({_id:req.params.id})
        await  UserType.updateOne(
            {$pull: {Permisions: {_id:permision._id}}}, 
            function(err,docs){
            if(err){
                console.log(err)
            }
        })
        await Permision.findOneAndRemove({_id:permision._id}, function(err){
            if(err){
                console.log(err)
            }else{
               res.redirect(req.get('referer')) 
            }
        });
}
//----------------------------------------------------------------
exports.getSetting=async (req,res)=>{
    var useradmin =await User.findOne({_id:req.user._id});

    var setting = await Setting.findOne();
    res.render('admin/setting/index',{setting,useradmin})
}
exports.postSetting=async (req,res)=>{
    var defualtrights = req.body.DefualtRights;
    var setting = await Setting.find();
    if(setting.length==0){
        var newSetting = new Setting({
            DefualtRights:parseInt(defualtrights),

        })
        await newSetting.save(async function(err,result){
            if(err){
                console.log(err)
            }else{
                console.log(result)
                res.redirect(req.get('referer'))
            }
        })
    }else {
        Setting.updateOne(
            {_id: setting[0]._id},
            {
                $set: {
                    DefualtRights: parseInt(defualtrights)
                }
            },
            function (err, doc) {
                if (err) {
                    console.log(err)
                } else {
                    res.redirect(req.get("referer"))
                }
            }
        )
    }
}

exports.getLogOut = async (req,res)=>{
    req.session.destroy(
        function (err) {
            if(!err){
                console.log("logout");
                res.redirect("../../")
            } else {
                console.log("logout");
                res.redirect("../../")
            }
        })
}