//------------- Requires ------------------
const connection = require('../../../config/database');
const Album = connection.models.Album;
const File = connection.models.File;
const User = connection.models.User;
const Project = connection.models.Project;
const fs = require('fs')
const generateDate = require("../../../lib/publicFunctions").generateDate;
const socketiofileupload = require('socketio-file-upload')
const  path = require('path');
require("dotenv").config({path: "./.env"});
//----------------------------------------FS

// const dir = './assets/upload'

const imageTypes = ['.png', '.jpg', '.jpeg','.gif']
const videoTypes = ['.mp4', '.mkv']
const audioTypes = ['.mp3']
const documentTypes = ['.pdf']
const fontTypes=['.ttf','.woff','.eot']

//---------------------------------------------------------upload
exports.getUploadAlbumFiles = async (req, res, next) => {
    console.log("upload file")
    var currentUrl='./assets/upload/'+req.params.fileName;
    var newcurrentUrl='./assets/upload/'+new Date();

    if(req.params.id=='personnel'){
        FolderName='personnel';
    }
    if(imageTypes.includes(path.parse(currentUrl).ext)){resultType="image"} //image, 1 video, 2 audio, 3 voice , 4document
    else if(videoTypes.includes(path.parse(currentUrl).ext)){resultType="video"}
    else if(audioTypes.includes(path.parse(currentUrl).ext)){resultType="audio"}
    else if (documentTypes.includes(path.parse(currentUrl).ext)){resultType="document"}
    else if(fontTypes.includes(path.parse(currentUrl).ext)){resultType="font"}
    else{ 
        
        console.log(path.parse(currentUrl).ext)
          
        fs.unlink(currentUrl, (err) => {
            if (err) {
                console.log(err)
            }
        
        });

        res.send({error:'filetype',text:'فرمت فایل شما تایید نشد'}); 
        
        return
    }
      
         var file = await File.findOne({Name:req.params.fileName})
         if(file){
            console.log("file")
            
            fs.unlink(currentUrl, (err) => {
                if (err) {
                    console.log(err)

                }
            
            });

            res.send({error:'exist',text:'فایلی با این اسم موجود می باشد'})
            return;
         }else{
                var random = Math.floor((Math.random() * 10000) + 1)+""+path.parse(currentUrl).ext;
        fs.rename(currentUrl, path.join(path.parse(currentUrl).dir,FolderName,random), function (err) {
            if (err) {
                res.send({error:'error',text:'آپلود فایل انجام نشد'})

                fs.unlink(currentUrl, (err) => {
                    if (err) {
                        console.log(err)
                    }
                
                });
                return;
            }
        });
         console.log()
        var resultName =random;
        var resultUrl='/upload/'+FolderName+'/'+resultName;

         }newFile = new File({
        Name: resultName,
        Alt: "طرح پرداز",
        Type: resultType,
        SmallCaption:"طرح پرداز",
        Caption:"طرح پرداز",
        IsCover:false,
        Status: 0,
        PersianDate: {
            Add: await generateDate(0, 'fa'),
           
        },
        Url: resultUrl,
    })
        
   
     
    

    await newFile.save(async function(err, result){
        if (err) {
                 console.log(err)            
        } else {
           res.send({error:'ok',text:result});
        }
    })

    

};

exports.getUploadUserFiles = async (req, res, next) => {

    console.log("getUploadUserFiles")

    var user = await User.findOne({_id: req.user._id})

    console.log("upload file")
    const imageTypes = ['png', 'jpg', 'jpeg']
    const videoTypes = ['mp4', 'mkv']
    const audioTypes = ['mp3']
    const documentTypes = ['pdf']

    var alt = ""

    switch (req.params.type.toLowerCase().trim()) {
        case "profileimage":
            alt = "تصویر پروفایل"
            break;
        case "resume":
            alt = "نمونه کارها"
            break;
        case "project":
            alt = "تصاویر پروژه"
            break;
        default:
            alt = "تصاویر پروژه"
    }

    var album = await Album.findOne({Name: req.user.Mobile})
    console.log("album")
    console.log(album)

    url = album.UniqueName

    console.log("url")
    console.log(url)

    await  exampleMode('./assets/assets/file/album/' + url);

    var newFile;
    var name;
    var type;

    await fs.moveSync('./assets/assets/file/album/'+ req.params.fileName , './assets/assets/file/album/' + url + '/' + req.params.fileName, { overwrite: true })
    name = req.params.fileName.split(".")
    if(imageTypes.includes(name[name.length - 1])) {
        type = 0
    } else if(videoTypes.includes(name[name.length - 1])){
        type = 1
    } else if(audioTypes.includes(name[name.length - 1])){
        type = 2
    } else if(documentTypes.includes(name[name.length - 1])){
        type = 3
    } else {
        type = 4
    }
    newFile = new File({
        Name: req.params.fileName,
        Alt: alt,
        Type: type,
        SmallCaption:"تصاویر کاربر",
        Caption:"تصاویر کاربر",
        IsCover:false,
        Status: 0,
        TarikhPersian: await persianDate(0),
        Views: '0',
        Likes: '0',
        Url: url,
        AdminConfirm: 0,
        Album: album._id,
        Removed: false
    })

    await newFile.save()

    var model;

    switch (req.params.type.toLowerCase().trim()) {
        case "profileimage":
            model = await User.findOne({_id: user._id}).populate("ProfileImage")

            console.log("model.ProfileImage._id")
            console.log(model.ProfileImage._id)

            await  File.updateOne({
                    _id: model.ProfileImage._id
                },{
                    $set: {
                        Removed : true
                    }
                },{ safe: true, multi:true }
            );

            model.ProfileImage = newFile
            break;
        case "resume":
            model = await User.findOne({_id: req.params.modelId}).populate("Files")
            model.Files.push(newFile)
            break;
        case "project":
            model = await Project.findOne({_id: req.params.modelId}).populate("Files")
            model.Files.push(newFile)
            break;
        default:
            model = await Project.findOne({_id: req.params.modelId}).populate("Files")
            model.Files.push(newFile)
    }

    await model.save();

    res.send({ "file" : newFile, "status: ": 200 });

};
//----------------------------------------------------------upload

//----------------------------------------------------------Remove
exports.getRemoveAlbumFiles = async (req, res) => {
    var file = await File.findOne({_id: req.params.fileId})
    await  File.updateOne({
            _id: req.params.fileId
        },{
            $set: {
                Removed : true
            }
        },{ safe: true, multi:true },
        async  function removeConnectionsCB(err, obj) {
            if (err) {
                res.send(err)
            }else {
                res.redirect(req.get('referer'));
            }
        }
    );
};

exports.getRemoveUserFiles = async (req, res) => {

    console.log("getRemoveUserFiles")

    var user = await User.findOne({_id: req.user._id})
    var file = await File.findOne({_id: req.params.imageID})

    switch (req.params.type.toLowerCase().trim()) {
        case "resume":
            model = await User.findOne({_id: req.params.modelId}).populate("Files")
            model.Files.pull(file)
            break;
        case "project":
            model = await Project.findOne({_id: req.params.modelId}).populate("Files")
            model.Files.pull(file)
            break;
        default:
            model = await Project.findOne({_id: req.params.modelId}).populate("Files")
            model.Files.pull(file)
    }

    model.save();

    await  File.updateOne({
            _id: req.params.imageID
        },{
            $set: {
                Removed : true
            }
        },{ safe: true, multi:true },
        async  function removeConnectionsCB(err, obj) {
            if (err) {
                res.send(err)
            }else {

                try {
                    await fs.remove('./assets/assets/file/album/'+ file.Url +'/'+ file.Name)
                    console.log('success!')
                } catch (err) {
                    console.error(err)
                }
                res.redirect(req.get('referer'));
            }
        }
    );
};
//----------------------------------------------------------Remove

//----------------------------------------------------------AddAlt
exports.postEditFile = async (req, res, next) => {
    File.updateOne(
        {
            _id: req.params.imageID,
        },
        {
            $set: {
                Alt : req.body.Alt,
                Caption: req.body.Caption
            },
        },
        { multi: false, runValidators: true },
        function (err, docs) {
            if (err) {
                console.log(err);
            }
            switch (req.params.platform.toLowerCase()) {
                case "admin":
                    res.redirect(req.get("referer"));
                    break;
                case "website":
                    res.redirect(req.get("referer"));
                    break;
                case "mobile":
                    res.send({ status: 200, data: docs, message: "آپلود فایل" });
                    break;
                default:
                    res.redirect(req.get("referer"));
            }
        }
    );
};
//--------  --------------------------------------------------AddAlt

exports.getFiles=async(req,res)=>{   
    console.log(req.params.type)  
   var album =  await Album.findOne({FolderName:req.params.type});
   console.log(album)
   var files = await File.find({Album:album._id})
   console.log(files)
   res.send(files);

}