//------------- Requires ------------------
const generateSystemLog = require('../../lib/systemLog').generateSystemLog;
const generateMessage = require('../../lib/flashMessage').generateMessage;
const generateDate = require('../../lib/publicFunctions').generateDate;
const createFolder = require('../../lib/uploadFileFTP').createFolder;
const report = require('../../lib/report').setReport;
const config = require("../../config/general");
const connection = config.connection;
const User=connection.models.User;
require('dotenv').config({path: './.env'});
const jwt = require('jsonwebtoken')
const bcrypt=config.bcrypt;

//------------- Requires ------------------
//----------------------------------------------------------------------admin
//------------------------------List----------------------------
exports.getLogin = async (req, res) => {

    res.render("login/index",{ messages:req.flash('login')})
};
exports.PostLogin = async (req, res) => {
    try {
        const { email, password } = req.body;

        // بررسی خالی بودن ایمیل
        if (!email) {
            req.flash('login', {type:"error",message: 'The email field is empty' });
            return res.redirect('/login'); // توقف اجرای کد
        }

        // بررسی خالی بودن رمز عبور
        if (!password) {
            req.flash('login', { type:"error",message: 'The password field is empty' });
            return res.redirect('/login'); // توقف اجرای کد
        }

        // یافتن کاربر
        const user = await User.findOne({ Email: email });
        console.log("user", user);
        console.log("pass", password);

        // بررسی وجود کاربر
        if (!user) {
            req.flash('login', {type:"error", message: 'User is not registered with this email' });
            return res.redirect('/login'); // توقف اجرای کد
        }

        // بررسی رمز عبور
        const isMatch = await bcrypt.compare(password, user.Password);
        if (!isMatch) {
            req.flash('login', {type:"error", message: 'The password is wrong' });
            return res.redirect('/login'); // توقف اجرای کد
        }

        // تولید توکن‌ها
        const accessToken = jwt.sign({ user, isWeb: true }, process.env.ACCESS_TOKEN_SECRET, { expiresIn: '1m' });
        const refreshToken = jwt.sign({ user, isWeb: true }, process.env.REFRESH_TOKEN_SECRET, { expiresIn: '5h' });

        if (accessToken && refreshToken) {
            req.session.user = { accessToken, refreshToken };

            await req.session.save((err) => {
                if (err) {
                    req.flash('login',{type:"error",message:'Login was not successful'});
                    console.error("Session save error:", err);
                    return res.redirect('/login'); // توقف اجرای کد
                }

                req.flash('profile',{type:"success",message:'You are logged in'});
                return res.redirect('/profile'); // توقف اجرای کد
            });
        }
    }
    catch (error) {
        console.error('Unexpected error:', error);
        req.flash('login', {type:"error", message: 'An unexpected error occurred' });
        return res.redirect('/login'); // توقف اجرای
        }


    }


