
const connection = require('../config/database');
const User= connection.models.User;
const passport = require("passport");
const GoogleStrategy = require("passport-google-oauth20").Strategy;
require('dotenv').config({path: './.env'});
const jwt = require('jsonwebtoken')
const generatePassword = require('../lib/token.js')
const bcrypt = require('bcryptjs');

passport.use(new GoogleStrategy({
        clientID: process.env.GOOGLE_ClIENT_ID,
        clientSecret: process.env.GOOGLE_CLIENT_SECRET,
        callbackURL: 'https://front.razdeveloper.ir/auth/google/callback'
    },
    async function (accessToken, refreshToken, profile, done) {
        var email = profile.emails[0];
        if (email.verified) {
            var emailUser = email.value;
        } else {
            return done(new Error("Email not verified"), null); // خطای ایمیل تایید نشده
        }

        // بررسی وجود کاربر
        var checkUser = await User.findOne({ Email: emailUser });

        if (checkUser) {
            try {
                // تولید توکن‌ها
                const accessToken = jwt.sign({ user:checkUser, isWeb: true }, process.env.ACCESS_TOKEN_SECRET, { expiresIn: '1m' });
                const refreshToken = jwt.sign({ user:checkUser, isWeb: true }, process.env.REFRESH_TOKEN_SECRET, { expiresIn: '5h' });

                // ارسال توکن‌ها به done
                if (accessToken && refreshToken) {
                    // اضافه کردن توکن‌ها به req.user
                    return done(null, { accessToken, refreshToken });
                } else {
                    done(new Error("Failed to create tokens"), null);
                }
            } catch (error) {
                done(error, null);
            }
        } else {
            var gPass = await generatePassword.generatePassword();
            const hashedPassword = await bcrypt.hash(gPass, 10);

            // ذخیره کاربر جدید در دیتابیس
            const newUser = new User({
                UserName: profile.displayName,
                Name: profile.name.givenName,
                LastName: profile.familyName,
                Email: emailUser,
                Password: hashedPassword,
                Status: true,
                IdCheck: Math.floor(Math.random() * 10000),
                Follower: [],
                Following: [],
                UserType: null,
                Admin: false
            });

            try {
                await newUser.save();

                // تولید توکن‌ها برای کاربر جدید
                const accessToken = jwt.sign({ user:newUser, isWeb: true }, process.env.ACCESS_TOKEN_SECRET, { expiresIn: '1m' });
                const refreshToken = jwt.sign({ user:newUser, isWeb: true }, process.env.REFRESH_TOKEN_SECRET, { expiresIn: '5h' });

                if (accessToken && refreshToken) {
                    return done(null, { accessToken, refreshToken});
                } else {
                    done(new Error("Failed to create tokens"), null);
                }

            } catch (error) {
                done(error, null);
            }
        }
    }));

// ذخیره شناسه کاربر در سشن (در اینجا فقط کاربر ذخیره می‌شود)
passport.serializeUser((user, done) => {
    done(null, user);
});

// بازیابی اطلاعات کاربر از سشن
passport.deserializeUser(async (id, done) => {
    try {
        done(null, id); // چون `id` همین کاربر است، نیاز به بازیابی از دیتابیس نداریم.
    } catch (err) {
        done(err, null);
    }
});