//------------- Requires ------------------
const jwt = require('jsonwebtoken')
const connection = require('../config/database');
require("dotenv").config({path: "../.env"});
//------------- Requires ------------------

const checkSocketAuth = (auth, callback) => {
    const token = auth;

    if (!token) {
        return callback({ status: 401, message: 'No token available' });
    }

    jwt.verify(token, process.env.REFRESH_TOKEN_SECRET, (err, user) => {
        if (err) {
            if (err.name === 'TokenExpiredError') {
                return callback({ status: 401, message: 'The token has expired' });
            }
            return callback({ status: 403, message: 'The token is invalid' });
        }
        callback(null, user);
    });



};

module.exports.checkSocketAuth = checkSocketAuth;