//------------- Requires ------------------
const config = require("../config/general")
// const IPData = require('ipdata').default;
const connection = config.connection;
const SystemLog = connection.models.SystemLog;
const User = connection.models.User;
var macaddress = require('macaddress');
//------------- Requires ------------------
async function generateCaption(action, status){
    // case 407:
    //     caption: "عملیات" + action + ""
    //     break;
    var caption = "";
    switch (status){
        case 200:
            caption = "عملیات" + action + "با موفقیت انجام شد."
            break;
        case 401:
            caption = "عملیات" + action + "نیاز به ورود به پنل کاربری دارد"
            break;
        case 402:
            caption = "عملیات" + action + "به دلیل تغییر آدرس یا حذف صفحه انجام نشد"
            break;
        case 403:
            caption = "عملیات" + action + "نیاز به سطح دسترسی متفاوتی دارد"
            break;
        case 404:
            caption = "عملیات" + action + "صفحه یافت نشد"
            break;
        case 405:
            caption = "عملیات" + action + "به دلیل ارسال درخواست برای پروژه غیرمجاز انجام نشد"
            break;
        case 406:
            caption = "عملیات" + action + "امکان تغییر در این وضعیت وجود ندارد"
            break;
        case 407:
            caption = "عملیات" + action + "شماره اشتباه وارد شده است"
            break;
        case 408:
            caption = "عملیات" + action + "قبلا ثبت شده است"
            break;
        case 409:
            caption = "عملیات" + action + "خطای کاوه نگار"
            break;
        case 410:
            caption = "عملیات" + action + "داده در پایگاه داده ثبت نشد"
            break;
        case 411:
            caption = "عملیات" + action + "داده در پایگاه داده یافت نشد"
            break;
        default:
            caption = "عملیات" + action + "با نتیجه نامشخص"
    }
    return caption
}

async function generateSystemLog(action, status, req, err=""){

    var macIp;
    await macaddress.one().then(async function (mac) {
        console.log("Mac address for this host: %s", mac);
        macIp = await mac;
    });

    var log
    var user = ""
    if(req.user){
        user = await User.findOne({ _id: req.user._id })

        log = new SystemLog({
            User: user._id,
            IP: 1,
            PervPage: req.session.prePage,
            PrevUrl: await req.get("referer"),
            CurrentUrl: req.originalUrl,
            Action: action,
            MacIP:macIp,
            Caption: await generateCaption(action, status),
            Time: await Date(),
            Status: status,
            Error: err,
            Removed: false
        })
    } else {
        log = new SystemLog({
            User: null,
            IP: 1,
            PervPage: req.session.prePage,
            PrevUrl: await req.get("referer"),
            CurrentUrl: req.originalUrl,
            Action: action,
            MacIP:macIp,
            Caption: await generateCaption(action, status),
            Time: await Date(),
            Status: status,
            Error: err,
            Removed: false
        })
    }

    log.save(async function(err, result){
        if(err) {
            console.log("err: " + err)
            return err
        } else {
            console.log("system log")
            console.log(log)
            return log
        }
    })
}
//----------------------------------------exports
module.exports.generateSystemLog = generateSystemLog;
