//------------- Requires ------------------
//------------- Requires ------------------
const config = require("../../config/general")
const multer = require('multer');
const express = config.express;
const router = express.Router({mergeParams: true});
const chatLoginControllers = require('../../controllers/account/account')
const authentication = require("../../lib/authFunctions");
const path = require('path')
//----------------------------------------------------------------------
const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        cb(null, 'assets/upload/images/avatar'); // مسیر ذخیره‌سازی فایل‌ها
    },
    filename: function (req, file, cb) {
        const ext = path.extname(file.originalname).toLowerCase(); // دریافت پسوند فایل
        const fileName = Date.now() + ext; // ترکیب نام یکتا با پسوند اصلی
        cb(null, fileName);
    }
});
// محدودیت‌ها
const fileFilter = (req, file, cb) => {
    const allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
    if (allowedTypes.includes(file.mimetype)) {
        cb(null, true);
    } else {
        cb(new Error('فرمت فایل مجاز نیست! فقط تصاویر با فرمت JPEG, PNG, GIF, WEBP قابل قبول هستند.'), false);
    }
};
const upload = multer({ storage: storage,

    limits: { fileSize: 3 * 1024 * 1024 }, // حداکثر حجم 2 مگابایت
    fileFilter: fileFilter
});
//------------------------------Login--------------------------
router.get("/",authentication.isAuthenticated,chatLoginControllers.index);
router.post("/edit",authentication.isAuthenticated,chatLoginControllers.postEditUser);
router.post("/editPass",authentication.isAuthenticated,chatLoginControllers.PostEditPassUser);
router.post("/editAvatar",authentication.isAuthenticated,upload.single('file'),chatLoginControllers.PostEditAvatar);
//------------------------------Login---------------------------

module.exports = router;